﻿//////////////////////////////////////////////
// ProjectLoader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;

	struct ProjectLoadQuery ;
	struct ProjectSaveQuery ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "ProjectLoadResult.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ProjectLoader final
	{
		public :

			// Constructor
			ProjectLoader (System* system) noexcept ;

			// Save
			void save (const ProjectSaveQuery& saveQuery) ;

			// Load
			ProjectLoadResult load (const ProjectLoadQuery& loadQuery) ;

		private :

			// Attributes
			System* _system ;
	} ;
}